var MemoryAnalyzer = {};
(function (MemoryAnalyzer) {
    var FormattingHelpers = (function () {
        function FormattingHelpers() { }
        FormattingHelpers.zeroPad = function zeroPad(stringToPad, newLength, padLeft) {
            for (var i = stringToPad.length; i < newLength; i++) {
                stringToPad = (padLeft ? ("0" + stringToPad) : (stringToPad + "0"));
            }
            return stringToPad;
        };
        FormattingHelpers.forceNonBreakingSpaces = function forceNonBreakingSpaces(stringToConvert) {
            var substitutedString = stringToConvert.replace(/\s/g, function ($0, $1, $2) {
                return "\u00a0";
            });
            return substitutedString;
        };
        FormattingHelpers.forceHtmlRendering = function forceHtmlRendering(stringToConvert) {
            return stringToConvert.replace(/[<>]/g, function ($0, $1, $2) {
                return ($0 === "<") ? "&lt;" : "&gt;";
            });
        };
        FormattingHelpers.trimLongString = function trimLongString(stringToConvert) {
            var substitutedString = stringToConvert;
            var maxStringLength = 38;
            if (stringToConvert.length > maxStringLength) {
                var substrLength = (maxStringLength / 2) - 2;
                substitutedString = stringToConvert.substr(0, substrLength) + "\u2026" + stringToConvert.substr(-(substrLength));
            }
            return substitutedString;
        };
        FormattingHelpers.getNativeDigitLocaleString = function getNativeDigitLocaleString(stringToConvert) {
            var nf = Microsoft.Plugin.Culture.NumberFormat;
            if (!nf) {
                nf = {
                    nativeDigits: ["0", "1", "2", "3", "4", "5", "6", "7", "8", "9"]
                };
            }
            var substitutedString = stringToConvert.replace(/\d/g, function ($0, $1, $2) {
                return (nf.nativeDigits[parseInt($0)]);
            });
            return substitutedString;
        };
        FormattingHelpers.forceNumberSign = function forceNumberSign(numberToConvert, positive) {
            var nf = Microsoft.Plugin.Culture.NumberFormat;
            if (!nf) {
                nf = {
                    positiveSign: "+",
                    negativeSign: "-",
                };
            }
            if (positive === true) {
                return nf.positiveSign + numberToConvert;
            }
            return nf.negativeSign + numberToConvert;
        };
        FormattingHelpers.getDecimalLocaleString = function getDecimalLocaleString(numberToConvert, includeGroupSeparators, includeSign) {
            var positive = true;
            if (numberToConvert == 0)
                includeSign = false;
            if (numberToConvert < 0) {
                positive = false;
                numberToConvert = numberToConvert * -1;
            }
            var numberString = numberToConvert.toString();
            var nf = Microsoft.Plugin.Culture.NumberFormat;
            if (!nf) {
                nf = {
                    numberDecimalSeparator: ".",
                    numberGroupSizes: [
                        3
                    ],
                    numberGroupSeparator: ",",
                };
            }
            numberString = FormattingHelpers.getNativeDigitLocaleString(numberString);
            var split = numberString.split(/e/i);
            numberString = split[0];
            var exponent = (split.length > 1 ? parseInt(split[1], 10) : 0);
            split = numberString.split('.');
            numberString = split[0];
            var right = split.length > 1 ? split[1] : "";
            if (exponent > 0) {
                right = FormattingHelpers.zeroPad(right, exponent, false);
                numberString += right.slice(0, exponent);
                right = right.substr(exponent);
            }
            else {
                if (exponent < 0) {
                    exponent = -exponent;
                    numberString = FormattingHelpers.zeroPad(numberString, exponent + 1, true);
                    right = numberString.slice(-exponent, numberString.length) + right;
                    numberString = numberString.slice(0, -exponent);
                }
            }
            if (right.length > 0) {
                right = nf.numberDecimalSeparator + right;
            }
            if (includeGroupSeparators === true) {
                var groupSizes = nf.numberGroupSizes;
                var sep = nf.numberGroupSeparator;
                var curSize = groupSizes[0];
                var curGroupIndex = 1;
                var stringIndex = numberString.length - 1;
                var ret = "";
                while (stringIndex >= 0) {
                    if (curSize === 0 || curSize > stringIndex) {
                        if (ret.length > 0) {
                            numberString = numberString.slice(0, stringIndex + 1) + sep + ret + right;
                        }
                        else {
                            numberString = numberString.slice(0, stringIndex + 1) + right;
                        }
                        if (includeSign === true)
                            return FormattingHelpers.forceNumberSign(numberString, positive);
                        return numberString;
                    }
                    if (ret.length > 0) {
                        ret = numberString.slice(stringIndex - curSize + 1, stringIndex + 1) + sep + ret;
                    }
                    else {
                        ret = numberString.slice(stringIndex - curSize + 1, stringIndex + 1);
                    }
                    stringIndex -= curSize;
                    if (curGroupIndex < groupSizes.length) {
                        curSize = groupSizes[curGroupIndex];
                        curGroupIndex++;
                    }
                }
                if (includeSign === true)
                    return FormattingHelpers.forceNumberSign(numberString.slice(0, stringIndex + 1) + sep + ret + right, positive);
                return numberString.slice(0, stringIndex + 1) + sep + ret + right;
            }
            else {
                if (includeSign === true)
                    return FormattingHelpers.forceNumberSign(numberString + right, positive);
                return numberString + right;
            }
        };
        return FormattingHelpers;
    })();
    MemoryAnalyzer.FormattingHelpers = FormattingHelpers;
})(MemoryAnalyzer);

// SIG // Begin signature block
// SIG // MIIkEgYJKoZIhvcNAQcCoIIkAzCCI/8CAQExDzANBglg
// SIG // hkgBZQMEAgEFADB3BgorBgEEAYI3AgEEoGkwZzAyBgor
// SIG // BgEEAYI3AgEeMCQCAQEEEBDgyQbOONQRoqMAEEvTUJAC
// SIG // AQACAQACAQACAQACAQAwMTANBglghkgBZQMEAgEFAAQg
// SIG // 1WVk4j7Q4OXNyB5K8fn+hjWqTa4BHJduQz7pV6172rOg
// SIG // gg2TMIIGETCCA/mgAwIBAgITMwAAAI6HkaRXGl/KPgAA
// SIG // AAAAjjANBgkqhkiG9w0BAQsFADB+MQswCQYDVQQGEwJV
// SIG // UzETMBEGA1UECBMKV2FzaGluZ3RvbjEQMA4GA1UEBxMH
// SIG // UmVkbW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0IENvcnBv
// SIG // cmF0aW9uMSgwJgYDVQQDEx9NaWNyb3NvZnQgQ29kZSBT
// SIG // aWduaW5nIFBDQSAyMDExMB4XDTE2MTExNzIyMDkyMVoX
// SIG // DTE4MDIxNzIyMDkyMVowgYMxCzAJBgNVBAYTAlVTMRMw
// SIG // EQYDVQQIEwpXYXNoaW5ndG9uMRAwDgYDVQQHEwdSZWRt
// SIG // b25kMR4wHAYDVQQKExVNaWNyb3NvZnQgQ29ycG9yYXRp
// SIG // b24xDTALBgNVBAsTBE1PUFIxHjAcBgNVBAMTFU1pY3Jv
// SIG // c29mdCBDb3Jwb3JhdGlvbjCCASIwDQYJKoZIhvcNAQEB
// SIG // BQADggEPADCCAQoCggEBANCH1EIrfp3ZxnrUosPjFZLS
// SIG // U52VF8lSNvpUv6sQr+nJ58wmU8PCc79t1gDlANzpamc0
// SIG // MPYWF7QBpZV8i7mkLOaLO3n2Iwx5j/NS30ABHMLGA53r
// SIG // Wc9z6dhxOZvwziVZLdLJWwrvftYyDl10EgTsngRTpmsC
// SIG // Z/hNWYt34Csh4O/ApEUSzwN7A8Y5w9Qi3FVcd0L/nLLl
// SIG // VWdoui12an9mU0fVRwrMON6Ne5cZfYLQJviljuWh8F5k
// SIG // EOT56yfG8uAI0A3yZ8DY8i/7idoV+a4PPgCXB9ELPnDU
// SIG // d6tyeEGYB7gXzKKxX+y981Bno9eU8NKLVY9TppWT5rJm
// SIG // z8k3aORjx88CAwEAAaOCAYAwggF8MB8GA1UdJQQYMBYG
// SIG // CisGAQQBgjdMCAEGCCsGAQUFBwMDMB0GA1UdDgQWBBSr
// SIG // yNbtshXSqo7xzO1sOPdFStCKuzBSBgNVHREESzBJpEcw
// SIG // RTENMAsGA1UECxMETU9QUjE0MDIGA1UEBRMrMjMwMDEy
// SIG // K2IwNTBjNmU3LTc2NDEtNDQxZi1iYzRhLTQzNDgxZTQx
// SIG // NWQwODAfBgNVHSMEGDAWgBRIbmTlUAXTgqoXNzcitW2o
// SIG // ynUClTBUBgNVHR8ETTBLMEmgR6BFhkNodHRwOi8vd3d3
// SIG // Lm1pY3Jvc29mdC5jb20vcGtpb3BzL2NybC9NaWNDb2RT
// SIG // aWdQQ0EyMDExXzIwMTEtMDctMDguY3JsMGEGCCsGAQUF
// SIG // BwEBBFUwUzBRBggrBgEFBQcwAoZFaHR0cDovL3d3dy5t
// SIG // aWNyb3NvZnQuY29tL3BraW9wcy9jZXJ0cy9NaWNDb2RT
// SIG // aWdQQ0EyMDExXzIwMTEtMDctMDguY3J0MAwGA1UdEwEB
// SIG // /wQCMAAwDQYJKoZIhvcNAQELBQADggIBAESJAqxpU/PE
// SIG // trvUjGBT58psqElpZr6lmkGZOtid0lcCUWr6v5uW26Ym
// SIG // fQlW6NztJXV6pUdSqB5LFlPz7g+awwSVKcGChKRWMfyg
// SIG // ipGVtb9azqkBH2RGoebK8dd0e7+SCFFefDMCXlE7m+XY
// SIG // Ll8CTAmcGkPace3k2eei2nQsF63lDLUY9VQJ1L4cc80g
// SIG // e6T6yNvY2zqu+pDFo72VZa5GLVcpWNaS8GzaY/GPM6J+
// SIG // OHZe3fM17ayaO2KB0E4ZfEh8sAuPOMwtvNU5ZamVwQPi
// SIG // ksm5q9JXCqrcUgsuViej4piXV468qVluJJKOguIJc4LZ
// SIG // NYPMn3/RBI6IuOKag1iw1JrmMfqUR459puJOefPY02oz
// SIG // FlBw8UK7mAnp/8yVVVsIv5JSqAjE8ejx/0DX+Zo2nf26
// SIG // kIXSVT5QrUYf7yUMuJ46SARj73iYol0DDQLY3CCr5la1
// SIG // 3u8WZsPXVYIeT4J4yZ5UGhBgtxerQBORrrAZwZozne4y
// SIG // cs1lzE9GmC0PUWAefPv+2+gHeQf3oTM4/gma2497tjq9
// SIG // hYa4zLx9ATC3ex2pXRu9zE0X925HM9VA32rKLlG4tbnP
// SIG // wwTTO+Xj6RCM66e63qQuM2opLxRK6h7BIjg1BYXvwgQA
// SIG // DWvB2JYUSBWvflKwuGDEUrVKgreFKgBJKiaDJ1pB3r3V
// SIG // Zkm8C5x4cAm8MIIHejCCBWKgAwIBAgIKYQ6Q0gAAAAAA
// SIG // AzANBgkqhkiG9w0BAQsFADCBiDELMAkGA1UEBhMCVVMx
// SIG // EzARBgNVBAgTCldhc2hpbmd0b24xEDAOBgNVBAcTB1Jl
// SIG // ZG1vbmQxHjAcBgNVBAoTFU1pY3Jvc29mdCBDb3Jwb3Jh
// SIG // dGlvbjEyMDAGA1UEAxMpTWljcm9zb2Z0IFJvb3QgQ2Vy
// SIG // dGlmaWNhdGUgQXV0aG9yaXR5IDIwMTEwHhcNMTEwNzA4
// SIG // MjA1OTA5WhcNMjYwNzA4MjEwOTA5WjB+MQswCQYDVQQG
// SIG // EwJVUzETMBEGA1UECBMKV2FzaGluZ3RvbjEQMA4GA1UE
// SIG // BxMHUmVkbW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0IENv
// SIG // cnBvcmF0aW9uMSgwJgYDVQQDEx9NaWNyb3NvZnQgQ29k
// SIG // ZSBTaWduaW5nIFBDQSAyMDExMIICIjANBgkqhkiG9w0B
// SIG // AQEFAAOCAg8AMIICCgKCAgEAq/D6chAcLq3YbqqCEE00
// SIG // uvK2WCGfQhsqa+laUKq4BjgaBEm6f8MMHt03a8YS2Avw
// SIG // OMKZBrDIOdUBFDFC04kNeWSHfpRgJGyvnkmc6Whe0t+b
// SIG // U7IKLMOv2akrrnoJr9eWWcpgGgXpZnboMlImEi/nqwhQ
// SIG // z7NEt13YxC4Ddato88tt8zpcoRb0RrrgOGSsbmQ1eKag
// SIG // Yw8t00CT+OPeBw3VXHmlSSnnDb6gE3e+lD3v++MrWhAf
// SIG // TVYoonpy4BI6t0le2O3tQ5GD2Xuye4Yb2T6xjF3oiU+E
// SIG // GvKhL1nkkDstrjNYxbc+/jLTswM9sbKvkjh+0p2ALPVO
// SIG // VpEhNSXDOW5kf1O6nA+tGSOEy/S6A4aN91/w0FK/jJSH
// SIG // vMAhdCVfGCi2zCcoOCWYOUo2z3yxkq4cI6epZuxhH2rh
// SIG // KEmdX4jiJV3TIUs+UsS1Vz8kA/DRelsv1SPjcF0PUUZ3
// SIG // s/gA4bysAoJf28AVs70b1FVL5zmhD+kjSbwYuER8ReTB
// SIG // w3J64HLnJN+/RpnF78IcV9uDjexNSTCnq47f7Fufr/zd
// SIG // sGbiwZeBe+3W7UvnSSmnEyimp31ngOaKYnhfsi+E11ec
// SIG // XL93KCjx7W3DKI8sj0A3T8HhhUSJxAlMxdSlQy90lfdu
// SIG // +HggWCwTXWCVmj5PM4TasIgX3p5O9JawvEagbJjS4NaI
// SIG // jAsCAwEAAaOCAe0wggHpMBAGCSsGAQQBgjcVAQQDAgEA
// SIG // MB0GA1UdDgQWBBRIbmTlUAXTgqoXNzcitW2oynUClTAZ
// SIG // BgkrBgEEAYI3FAIEDB4KAFMAdQBiAEMAQTALBgNVHQ8E
// SIG // BAMCAYYwDwYDVR0TAQH/BAUwAwEB/zAfBgNVHSMEGDAW
// SIG // gBRyLToCMZBDuRQFTuHqp8cx0SOJNDBaBgNVHR8EUzBR
// SIG // ME+gTaBLhklodHRwOi8vY3JsLm1pY3Jvc29mdC5jb20v
// SIG // cGtpL2NybC9wcm9kdWN0cy9NaWNSb29DZXJBdXQyMDEx
// SIG // XzIwMTFfMDNfMjIuY3JsMF4GCCsGAQUFBwEBBFIwUDBO
// SIG // BggrBgEFBQcwAoZCaHR0cDovL3d3dy5taWNyb3NvZnQu
// SIG // Y29tL3BraS9jZXJ0cy9NaWNSb29DZXJBdXQyMDExXzIw
// SIG // MTFfMDNfMjIuY3J0MIGfBgNVHSAEgZcwgZQwgZEGCSsG
// SIG // AQQBgjcuAzCBgzA/BggrBgEFBQcCARYzaHR0cDovL3d3
// SIG // dy5taWNyb3NvZnQuY29tL3BraW9wcy9kb2NzL3ByaW1h
// SIG // cnljcHMuaHRtMEAGCCsGAQUFBwICMDQeMiAdAEwAZQBn
// SIG // AGEAbABfAHAAbwBsAGkAYwB5AF8AcwB0AGEAdABlAG0A
// SIG // ZQBuAHQALiAdMA0GCSqGSIb3DQEBCwUAA4ICAQBn8oal
// SIG // mOBUeRou09h0ZyKbC5YR4WOSmUKWfdJ5DJDBZV8uLD74
// SIG // w3LRbYP+vj/oCso7v0epo/Np22O/IjWll11lhJB9i0ZQ
// SIG // VdgMknzSGksc8zxCi1LQsP1r4z4HLimb5j0bpdS1HXeU
// SIG // OeLpZMlEPXh6I/MTfaaQdION9MsmAkYqwooQu6SpBQyb
// SIG // 7Wj6aC6VoCo/KmtYSWMfCWluWpiW5IP0wI/zRive/DvQ
// SIG // vTXvbiWu5a8n7dDd8w6vmSiXmE0OPQvyCInWH8MyGOLw
// SIG // xS3OW560STkKxgrCxq2u5bLZ2xWIUUVYODJxJxp/sfQn
// SIG // +N4sOiBpmLJZiWhub6e3dMNABQamASooPoI/E01mC8Cz
// SIG // TfXhj38cbxV9Rad25UAqZaPDXVJihsMdYzaXht/a8/jy
// SIG // FqGaJ+HNpZfQ7l1jQeNbB5yHPgZ3BtEGsXUfFL5hYbXw
// SIG // 3MYbBL7fQccOKO7eZS/sl/ahXJbYANahRr1Z85elCUtI
// SIG // EJmAH9AAKcWxm6U/RXceNcbSoqKfenoi+kiVH6v7RyOA
// SIG // 9Z74v2u3S5fi63V4GuzqN5l5GEv/1rMjaHXmr/r8i+sL
// SIG // gOppO6/8MO0ETI7f33VtY5E90Z1WTk+/gFcioXgRMiF6
// SIG // 70EKsT/7qMykXcGhiJtXcVZOSEXAQsmbdlsKgEhr/Xmf
// SIG // wb1tbWrJUnMTDXpQzTGCFdcwghXTAgEBMIGVMH4xCzAJ
// SIG // BgNVBAYTAlVTMRMwEQYDVQQIEwpXYXNoaW5ndG9uMRAw
// SIG // DgYDVQQHEwdSZWRtb25kMR4wHAYDVQQKExVNaWNyb3Nv
// SIG // ZnQgQ29ycG9yYXRpb24xKDAmBgNVBAMTH01pY3Jvc29m
// SIG // dCBDb2RlIFNpZ25pbmcgUENBIDIwMTECEzMAAACOh5Gk
// SIG // Vxpfyj4AAAAAAI4wDQYJYIZIAWUDBAIBBQCggcYwGQYJ
// SIG // KoZIhvcNAQkDMQwGCisGAQQBgjcCAQQwHAYKKwYBBAGC
// SIG // NwIBCzEOMAwGCisGAQQBgjcCARUwLwYJKoZIhvcNAQkE
// SIG // MSIEIIfVBwmn4omz5uupXY+BCWl5tfYIfgObVvOvqZo/
// SIG // HwZMMFoGCisGAQQBgjcCAQwxTDBKoDCALgBNAGEAbgBh
// SIG // AGcAZQBkAE0AZQBtAG8AcgB5AEgAZQBsAHAAZQByAHMA
// SIG // LgBqAHOhFoAUaHR0cDovL21pY3Jvc29mdC5jb20wDQYJ
// SIG // KoZIhvcNAQEBBQAEggEAlByLGFvqRxH1Ck1fnsMl/c32
// SIG // +Zpi//JGwKQw8IHN92DzJJN5NAx1XJTXcDdNYJqA6obR
// SIG // r8vHBmsohxNJqzIoqXrceWwQghmcF0Fgc4kbgKpwniXa
// SIG // RmJYXEvNHEx3vstrezIR3/Fd7Btds2VQQa4epTrdMBcW
// SIG // q9/69pv3W2vJDvU5v3lJd3sFg3ibobAejqi94/Ens/vB
// SIG // VdyGVvuy7JHdmi+9P7Gvw+e2pDnQFXMOC8Uy1pq3vgWW
// SIG // O3U0piRaH9dDbAuYdn77Ot3RUuTqmetPrV+TiPJ+nAkv
// SIG // HKxm3Y3+YND+pNMaptiH65ZEFW+gM8xXag+1IPVmsMIo
// SIG // jrCDAwAbMKGCE0kwghNFBgorBgEEAYI3AwMBMYITNTCC
// SIG // EzEGCSqGSIb3DQEHAqCCEyIwghMeAgEDMQ8wDQYJYIZI
// SIG // AWUDBAIBBQAwggE9BgsqhkiG9w0BCRABBKCCASwEggEo
// SIG // MIIBJAIBAQYKKwYBBAGEWQoDATAxMA0GCWCGSAFlAwQC
// SIG // AQUABCBsJqqr/OedrY/EkUwSrl1rapYsyh95T5bfXFUm
// SIG // gY10QQIGWK+K6HrwGBMyMDE3MDIyODEyMTQxNi40ODJa
// SIG // MAcCAQGAAgH0oIG5pIG2MIGzMQswCQYDVQQGEwJVUzET
// SIG // MBEGA1UECBMKV2FzaGluZ3RvbjEQMA4GA1UEBxMHUmVk
// SIG // bW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0IENvcnBvcmF0
// SIG // aW9uMQ0wCwYDVQQLEwRNT1BSMScwJQYDVQQLEx5uQ2lw
// SIG // aGVyIERTRSBFU046NzI4RC1DNDVGLUY5RUIxJTAjBgNV
// SIG // BAMTHE1pY3Jvc29mdCBUaW1lLVN0YW1wIFNlcnZpY2Wg
// SIG // gg7MMIIGcTCCBFmgAwIBAgIKYQmBKgAAAAAAAjANBgkq
// SIG // hkiG9w0BAQsFADCBiDELMAkGA1UEBhMCVVMxEzARBgNV
// SIG // BAgTCldhc2hpbmd0b24xEDAOBgNVBAcTB1JlZG1vbmQx
// SIG // HjAcBgNVBAoTFU1pY3Jvc29mdCBDb3Jwb3JhdGlvbjEy
// SIG // MDAGA1UEAxMpTWljcm9zb2Z0IFJvb3QgQ2VydGlmaWNh
// SIG // dGUgQXV0aG9yaXR5IDIwMTAwHhcNMTAwNzAxMjEzNjU1
// SIG // WhcNMjUwNzAxMjE0NjU1WjB8MQswCQYDVQQGEwJVUzET
// SIG // MBEGA1UECBMKV2FzaGluZ3RvbjEQMA4GA1UEBxMHUmVk
// SIG // bW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0IENvcnBvcmF0
// SIG // aW9uMSYwJAYDVQQDEx1NaWNyb3NvZnQgVGltZS1TdGFt
// SIG // cCBQQ0EgMjAxMDCCASIwDQYJKoZIhvcNAQEBBQADggEP
// SIG // ADCCAQoCggEBAKkdDbx3EYo6IOz8E5f1+n9plGt0VBDV
// SIG // pQoAgoX77XxoSyxfxcPlYcJ2tz5mK1vwFVMnBDEfQRsa
// SIG // lR3OCROOfGEwWbEwRA/xYIiEVEMM1024OAizQt2TrNZz
// SIG // MFcmgqNFDdDq9UeBzb8kYDJYYEbyWEeGMoQedGFnkV+B
// SIG // VLHPk0ySwcSmXdFhE24oxhr5hoC732H8RsEnHSRnEnIa
// SIG // IYqvS2SJUGKxXf13Hz3wV3WsvYpCTUBR0Q+cBj5nf/Vm
// SIG // wAOWRH7v0Ev9buWayrGo8noqCjHw2k4GkbaICDXoeByw
// SIG // 6ZnNPOcvRLqn9NxkvaQBwSAJk3jN/LzAyURdXhacAQVP
// SIG // Ik0CAwEAAaOCAeYwggHiMBAGCSsGAQQBgjcVAQQDAgEA
// SIG // MB0GA1UdDgQWBBTVYzpcijGQ80N7fEYbxTNoWoVtVTAZ
// SIG // BgkrBgEEAYI3FAIEDB4KAFMAdQBiAEMAQTALBgNVHQ8E
// SIG // BAMCAYYwDwYDVR0TAQH/BAUwAwEB/zAfBgNVHSMEGDAW
// SIG // gBTV9lbLj+iiXGJo0T2UkFvXzpoYxDBWBgNVHR8ETzBN
// SIG // MEugSaBHhkVodHRwOi8vY3JsLm1pY3Jvc29mdC5jb20v
// SIG // cGtpL2NybC9wcm9kdWN0cy9NaWNSb29DZXJBdXRfMjAx
// SIG // MC0wNi0yMy5jcmwwWgYIKwYBBQUHAQEETjBMMEoGCCsG
// SIG // AQUFBzAChj5odHRwOi8vd3d3Lm1pY3Jvc29mdC5jb20v
// SIG // cGtpL2NlcnRzL01pY1Jvb0NlckF1dF8yMDEwLTA2LTIz
// SIG // LmNydDCBoAYDVR0gAQH/BIGVMIGSMIGPBgkrBgEEAYI3
// SIG // LgMwgYEwPQYIKwYBBQUHAgEWMWh0dHA6Ly93d3cubWlj
// SIG // cm9zb2Z0LmNvbS9QS0kvZG9jcy9DUFMvZGVmYXVsdC5o
// SIG // dG0wQAYIKwYBBQUHAgIwNB4yIB0ATABlAGcAYQBsAF8A
// SIG // UABvAGwAaQBjAHkAXwBTAHQAYQB0AGUAbQBlAG4AdAAu
// SIG // IB0wDQYJKoZIhvcNAQELBQADggIBAAfmiFEN4sbgmD+B
// SIG // cQM9naOhIW+z66bM9TG+zwXiqf76V20ZMLPCxWbJat/1
// SIG // 5/B4vceoniXj+bzta1RXCCtRgkQS+7lTjMz0YBKKdsxA
// SIG // QEGb3FwX/1z5Xhc1mCRWS3TvQhDIr79/xn/yN31aPxzy
// SIG // mXlKkVIArzgPF/UveYFl2am1a+THzvbKegBvSzBEJCI8
// SIG // z+0DpZaPWSm8tv0E4XCfMkon/VWvL/625Y4zu2JfmttX
// SIG // QOnxzplmkIz/amJ/3cVKC5Em4jnsGUpxY517IW3DnKOi
// SIG // PPp/fZZqkHimbdLhnPkd/DjYlPTGpQqWhqS9nhquBEKD
// SIG // uLWAmyI4ILUl5WTs9/S/fmNZJQ96LjlXdqJxqgaKD4kW
// SIG // umGnEcua2A5HmoDF0M2n0O99g/DhO3EJ3110mCIIYdqw
// SIG // UB5vvfHhAN/nMQekkzr3ZUd46PioSKv33nJ+YWtvd6mB
// SIG // y6cJrDm77MbL2IK0cs0d9LiFAR6A+xuJKlQ5slvayA1V
// SIG // mXqHczsI5pgt6o3gMy4SKfXAL1QnIffIrE7aKLixqduW
// SIG // sqdCosnPGUFN4Ib5KpqjEWYw07t0MkvfY3v1mYovG8ch
// SIG // r1m1rtxEPJdQcdeh0sVV42neV8HR3jDA/czmTfsNv11P
// SIG // 6Z0eGTgvvM9YBS7vDaBQNdrvCScc1bN+NR4Iuto229Nf
// SIG // j950iEkSMIIE2jCCA8KgAwIBAgITMwAAALI1BWg3IhwN
// SIG // pwAAAAAAsjANBgkqhkiG9w0BAQsFADB8MQswCQYDVQQG
// SIG // EwJVUzETMBEGA1UECBMKV2FzaGluZ3RvbjEQMA4GA1UE
// SIG // BxMHUmVkbW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0IENv
// SIG // cnBvcmF0aW9uMSYwJAYDVQQDEx1NaWNyb3NvZnQgVGlt
// SIG // ZS1TdGFtcCBQQ0EgMjAxMDAeFw0xNjA5MDcxNzU2NTda
// SIG // Fw0xODA5MDcxNzU2NTdaMIGzMQswCQYDVQQGEwJVUzET
// SIG // MBEGA1UECBMKV2FzaGluZ3RvbjEQMA4GA1UEBxMHUmVk
// SIG // bW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0IENvcnBvcmF0
// SIG // aW9uMQ0wCwYDVQQLEwRNT1BSMScwJQYDVQQLEx5uQ2lw
// SIG // aGVyIERTRSBFU046NzI4RC1DNDVGLUY5RUIxJTAjBgNV
// SIG // BAMTHE1pY3Jvc29mdCBUaW1lLVN0YW1wIFNlcnZpY2Uw
// SIG // ggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQCY
// SIG // SgG70Vj1f3SRQumhLlNd8iwgbxIum9PXlZXcnW+JfA5r
// SIG // cClNsC4PNVb2jwJL+HxVbVDNP8eqePIQB6gHawO7/Cvw
// SIG // qiWd3fzxY3AkZW+E+ktEXs5yKH3Csx/Fb4ZqmYeuuv7M
// SIG // BZi+b74Vgkdlty91yrzaEHqbOzJP2h1Ikg4i57GxQm1Z
// SIG // wmKeLCoK8DU3IAIJ7OEU47UX44B+VO5dUQ6T2ZpKM8mv
// SIG // Jg3r9msjlS8/XRIhN0okz469D5tTP+7p7oxwe9o79Wq5
// SIG // mTy32wF8Ess/Vc70r9YGuTo833wn1HKUza9KCTbGIuxd
// SIG // c7064oAaHfW9d3CNY3B7wMD27p40aYe3AgMBAAGjggEb
// SIG // MIIBFzAdBgNVHQ4EFgQUM2S+Z2sc3PljRAZI5MVDyZD2
// SIG // gpUwHwYDVR0jBBgwFoAU1WM6XIoxkPNDe3xGG8UzaFqF
// SIG // bVUwVgYDVR0fBE8wTTBLoEmgR4ZFaHR0cDovL2NybC5t
// SIG // aWNyb3NvZnQuY29tL3BraS9jcmwvcHJvZHVjdHMvTWlj
// SIG // VGltU3RhUENBXzIwMTAtMDctMDEuY3JsMFoGCCsGAQUF
// SIG // BwEBBE4wTDBKBggrBgEFBQcwAoY+aHR0cDovL3d3dy5t
// SIG // aWNyb3NvZnQuY29tL3BraS9jZXJ0cy9NaWNUaW1TdGFQ
// SIG // Q0FfMjAxMC0wNy0wMS5jcnQwDAYDVR0TAQH/BAIwADAT
// SIG // BgNVHSUEDDAKBggrBgEFBQcDCDANBgkqhkiG9w0BAQsF
// SIG // AAOCAQEAQeCyoKDK9ChvzI3d/tu9IFWJbCApdnY/1CfJ
// SIG // XnuD+8HCRzaN9nohTEQbOnFjqyMmv0SuohnvJ9ZYhrp6
// SIG // cPovtEvkcUg6V9K1/6MQG5oJw18eCegwzZHrVFzBC1n+
// SIG // 9OpSL6h6NWtgtoM4CaaadtuWs9c1h6hkOlwGz0wTDcYi
// SIG // GLcAY4y4dbFF4alHWtv//LsaHVQ52xVf5lfkNJ54L/20
// SIG // 3CDf0hMQo849cdnhsF5lWXuObO6Vs5nf8KgcYQ9MT1eq
// SIG // 1sQx9nwNYutsawChCoTSfHEpJyKk2BMPwHrInd06Oere
// SIG // JwbcBGGOPGqEmt9OtprtsEzh+lGNgEIFpib2g28B5qGC
// SIG // A3UwggJdAgEBMIHjoYG5pIG2MIGzMQswCQYDVQQGEwJV
// SIG // UzETMBEGA1UECBMKV2FzaGluZ3RvbjEQMA4GA1UEBxMH
// SIG // UmVkbW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0IENvcnBv
// SIG // cmF0aW9uMQ0wCwYDVQQLEwRNT1BSMScwJQYDVQQLEx5u
// SIG // Q2lwaGVyIERTRSBFU046NzI4RC1DNDVGLUY5RUIxJTAj
// SIG // BgNVBAMTHE1pY3Jvc29mdCBUaW1lLVN0YW1wIFNlcnZp
// SIG // Y2WiJQoBATAJBgUrDgMCGgUAAxUAvf/FlWOQ8ROcYNYZ
// SIG // wK/puJ4eIB2ggcIwgb+kgbwwgbkxCzAJBgNVBAYTAlVT
// SIG // MRMwEQYDVQQIEwpXYXNoaW5ndG9uMRAwDgYDVQQHEwdS
// SIG // ZWRtb25kMR4wHAYDVQQKExVNaWNyb3NvZnQgQ29ycG9y
// SIG // YXRpb24xDTALBgNVBAsTBE1PUFIxJzAlBgNVBAsTHm5D
// SIG // aXBoZXIgTlRTIEVTTjo0REU5LTBDNUUtM0UwOTErMCkG
// SIG // A1UEAxMiTWljcm9zb2Z0IFRpbWUgU291cmNlIE1hc3Rl
// SIG // ciBDbG9jazANBgkqhkiG9w0BAQUFAAIFANxfgaAwIhgP
// SIG // MjAxNzAyMjgwNDU3MDRaGA8yMDE3MDMwMTA0NTcwNFow
// SIG // czA5BgorBgEEAYRZCgQBMSswKTAKAgUA3F+BoAIBADAG
// SIG // AgEAAgEbMAcCAQACAhkLMAoCBQDcYNMgAgEAMDYGCisG
// SIG // AQQBhFkKBAIxKDAmMAwGCisGAQQBhFkKAwGgCjAIAgEA
// SIG // AgMW42ChCjAIAgEAAgMHoSAwDQYJKoZIhvcNAQEFBQAD
// SIG // ggEBADEWstF11LZV+OUGcZz0JjAqh9N/aWNeLanaI7Wt
// SIG // xQ+uWoHs6SzE4/mcyesvRLG5tJPMILEYdvJH3b/Kd4Wc
// SIG // NOsV/VdgnTnaaasupQFGXEFQsx6hEG3Fr3Mc3OUEPvHN
// SIG // i+GhCI8qQ3WOA0cfKAD8m8K/Oa2Fv4ehsixGekqIWaOb
// SIG // h3VMNKE7cW7GtV52T67rjGDrZS4Jg21HZiDxuItZsdxY
// SIG // cPcnh3McIGqS/Cn7jH2hZMvj3WnRQ0cLyr9PxPBbtUAH
// SIG // 10vyTVDlayyDiUDgTnbgXXDSl/yoaFzbhAnZtzqPA+QE
// SIG // IfsxXLk6IAO+p72v76ZxXGCPIXDuFKDFGORI8QkxggL1
// SIG // MIIC8QIBATCBkzB8MQswCQYDVQQGEwJVUzETMBEGA1UE
// SIG // CBMKV2FzaGluZ3RvbjEQMA4GA1UEBxMHUmVkbW9uZDEe
// SIG // MBwGA1UEChMVTWljcm9zb2Z0IENvcnBvcmF0aW9uMSYw
// SIG // JAYDVQQDEx1NaWNyb3NvZnQgVGltZS1TdGFtcCBQQ0Eg
// SIG // MjAxMAITMwAAALI1BWg3IhwNpwAAAAAAsjANBglghkgB
// SIG // ZQMEAgEFAKCCATIwGgYJKoZIhvcNAQkDMQ0GCyqGSIb3
// SIG // DQEJEAEEMC8GCSqGSIb3DQEJBDEiBCDWjcrUB0eoqMjv
// SIG // fdna5RrQB5z0GaLRbZLSghIeWQNpuTCB4gYLKoZIhvcN
// SIG // AQkQAgwxgdIwgc8wgcwwgbEEFL3/xZVjkPETnGDWGcCv
// SIG // 6bieHiAdMIGYMIGApH4wfDELMAkGA1UEBhMCVVMxEzAR
// SIG // BgNVBAgTCldhc2hpbmd0b24xEDAOBgNVBAcTB1JlZG1v
// SIG // bmQxHjAcBgNVBAoTFU1pY3Jvc29mdCBDb3Jwb3JhdGlv
// SIG // bjEmMCQGA1UEAxMdTWljcm9zb2Z0IFRpbWUtU3RhbXAg
// SIG // UENBIDIwMTACEzMAAACyNQVoNyIcDacAAAAAALIwFgQU
// SIG // 0f1m47LqTXaOytFJIhxlsyn/AicwDQYJKoZIhvcNAQEL
// SIG // BQAEggEAM7PU2fytQBntYvuaytNG0lsgsT0u7cbEAWDd
// SIG // IY13zxhU2Bi/Qmpx1stGU2gWTJp2qvZFKsTSq11sLLjk
// SIG // tb16acE2We6KKSNWoQ3LUs06X5IRF4gEVFD3L5VSrEXc
// SIG // EoAaaBLKA5FMP3lmQP0p8FcGcp3VoPHiWwTXIQd/jlbd
// SIG // yGVutjLP9wpeRO8gu3J6+rejKLAfcss951f6uhWAaA3n
// SIG // VRX8HeJLzdS32S0J2Vu0+YXkJcXyjQUub9hqNNfxmL+m
// SIG // 92Zh7ketK3dB9OzJAjVdSrO5KRVXjdygMkH1G9l2b0S4
// SIG // JWs6v8Bl9V1xkbfXAavQCvx/ayvSOrnYqRxlNsb6+Q==
// SIG // End signature block
